\ Ramanujan's Taxi

\ print integer solutions to the equation I^3+J^3 = K^3+L^3

\ usage: gforth -m 1G -e "1290 include rama-taxi.fs bye"
\ to print all solutions, where I, J, K, L < 1290

\ for more information on the problem read Vierte Dimension 3+4/2007 or
\ http://www.durangobill.com/Ramanujan.html

\ This program is described in
\ <2007Dec25.164446@mips.complang.tuwien.ac.at> ff. (in German).  It
\ exercises dictionary insertion and SEARCH-WORDLIST in hugw
\ wordlists, and EXECUTE-PARSING performance, and needs a large
\ dictionary (26MB on 32-bit Gforth with 1290 as input).

\ The program uses the following words
\ from CORE :
\  Constant Variable ! : dup * ; >r 2@ ['] Create r> , @ ." cr execute r@ IF 
\  ELSE cell+ +! THEN over + <# #s #> 2dup 2! i j LOOP . 
\ from CORE-EXT :
\  u.r ?DO .( 
\ from BLOCK-EXT :
\  \ 
\ from DOUBLE :
\  2Variable 
\ from FILE :
\  ( 
\ from SEARCH :
\  wordlist get-current set-current search-wordlist 
\ from X:required :
\  include 
\ from non-ANS :
\  execute-parsing 

\ You can get a standard implementation of EXECUTE-PARSING from
\ <http://www.complang.tuwien.ac.at/forth/compat.zip>

wordlist constant cube-sums

variable solutions 0 solutions !

: cubed ( n1 -- n2 )
    dup dup * * ;

variable sum
2variable sum-string

: insert-sum ( n1 n2 -- )
    get-current >r
    cube-sums set-current sum-string 2@ ['] create execute-parsing
    r> set-current
    0 , , , ;

: .sum ( -- )
    sum @ 12 u.r ;

: .pair ( n1 n2 -- )
    4 u.r ." ^3 + " 4 u.r ." ^3" ;

: found-solution ( n1 n2 xt -- )
    cr execute >r
    r@ @ if ( n1 n2 )
        ." Another solution for " .sum ." : "
    else
        .sum ."  = " r@ cell+ 2@ .pair ."  = "
        1 solutions +!
    then
    .pair
    1 r> +! ;
        
: check-taxi ( n1 n2 -- )
    over cubed over cubed + dup sum !
    ( sum ) 0 <# #s #> 2dup sum-string 2!
    cube-sums search-wordlist if ( n1 n2 xt )
        found-solution
    else ( n1 n2 )
        insert-sum
    then ;

: rama-taxis ( n -- )
    1 ?do
        i 1 ?do
            i j check-taxi
        loop
    loop ;

( n ) rama-taxis cr solutions @ . .( numbers)

    
