\ X11 interface

Module X11

also DOS

[IFDEF] osx
    s" /usr/X11/lib/libX11.dylib" file-status nip 0= [IF]
	library libX11 /usr/X11/lib/libX11.dylib
	library libXext /usr/X11/lib/libXext.dylib \ depends libX11
    [ELSE]
	library libX11 /usr/X11R6/lib/libX11.dylib
	library libXext /usr/X11R6/lib/libXext.dylib \ depends libX11
    [THEN]
[ELSE]
    library libX11 libX11.so.6
    library libXext libXext.so.6 \ depends libX11
[THEN]

base @ hex

' noop alias has-utf8
' noop alias has-png
' noop alias has-xft

legacy off

libX11 XGetModifierMapping int (int) XGetModifierMapping     ( dpy -- modmap )
libX11 XNewModifiermap int (int) XNewModifiermap ( maxkeys -- modmap )
libX11 XInitImage int (int) XInitImage      ( image -- status )
libX11 XOpenDisplay int (int) XOpenDisplay    ( name -- dpy )
libX11 XDisplayName int (int) XDisplayName    ( string -- string )
libX11 XKeysymToString int (int) XKeysymToString ( keysym -- string )
libX11 XGContextFromGC int (int) XGContextFromGC ( gc -- gcontext )
libX11 XStringToKeysym int (int) XStringToKeysym ( string -- keysym )
libX11 XMaxRequestSize int (int) XMaxRequestSize ( dpy -- n )
libX11 XExtendedMaxRequestSize int (int) XExtendedMaxRequestSize ( dpy -- n )
libX11 XResourceManagerString int (int) XResourceManagerString  ( dpy -- string )
libX11 XScreenResourceString int (int) XScreenResourceString   ( screen -- string )
libX11 XDisplayMotionBufferSize int (int) XDisplayMotionBufferSize        ( dpy -- u )
libX11 XVisualIDFromVisual int (int) XVisualIDFromVisual     ( visual -- visualID )
libX11 XLockDisplay int (int) XLockDisplay    ( dpy -- r )
libX11 XUnlockDisplay int (int) XUnlockDisplay  ( dpy -- r )
libX11 XAddExtension int (int) XAddExtension   ( dpy -- extcodes )
libX11 XEHeadOfExtensionList int (int) XEHeadOfExtensionList   ( object -- extdata** )
libX11 XDefaultRootWindow int (int) XDefaultRootWindow      ( dpy -- window )
libX11 XRootWindowOfScreen int (int) XRootWindowOfScreen     ( screen -- window )
libX11 XDefaultVisualOfScreen int (int) XDefaultVisualOfScreen  ( screen -- visual )
libX11 XDefaultGCOfScreen int (int) XDefaultGCOfScreen      ( screen -- gc )
libX11 XBlackPixelOfScreen int (int) XBlackPixelOfScreen     ( screen -- u )
libX11 XWhitePixelOfScreen int (int) XWhitePixelOfScreen     ( screen -- u )
libX11 XNextRequest int (int) XNextRequest    ( dpy -- u )
libX11 XLastKnownRequestProcessed int (int) XLastKnownRequestProcessed      ( dpy -- u )
libX11 XServerVendor int (int) XServerVendor   ( dpy -- string )
libX11 XDisplayString int (int) XDisplayString  ( dpy -- string )
libX11 XDefaultColormapOfScreen int (int) XDefaultColormapOfScreen        ( screen -- colormap )
libX11 XDisplayOfScreen int (int) XDisplayOfScreen        ( screen -- dpy )
libX11 XDefaultScreenOfDisplay int (int) XDefaultScreenOfDisplay ( dpy -- screen )
libX11 XEventMaskOfScreen int (int) XEventMaskOfScreen      ( screen -- mask )
libX11 XScreenNumberOfScreen int (int) XScreenNumberOfScreen   ( screen -- n )
libX11 XSetErrorHandler int (int) XSetErrorHandler        ( handler -- errorhandler )
libX11 XSetIOErrorHandler int (int) XSetIOErrorHandler      ( handler -- ioerrorhandler )
libX11 XFreeStringList int (int) XFreeStringList ( list -- r )
libX11 XActivateScreenSaver int (int) XActivateScreenSaver    ( dpy -- r )
libX11 XAutoRepeatOff int (int) XAutoRepeatOff  ( dpy -- r )
libX11 XAutoRepeatOn int (int) XAutoRepeatOn   ( dpy -- r )
libX11 XBitmapBitOrder int (int) XBitmapBitOrder ( dpy -- n )
libX11 XBitmapPad int (int) XBitmapPad      ( dpy -- n )
libX11 XBitmapUnit int (int) XBitmapUnit     ( dpy -- n )
libX11 XCellsOfScreen int (int) XCellsOfScreen  ( screen -- n )
libX11 XCloseDisplay int (int) XCloseDisplay   ( dpy -- r )
libX11 XConnectionNumber int (int) XConnectionNumber       ( dpy -- r )
libX11 XDefaultDepthOfScreen int (int) XDefaultDepthOfScreen   ( screen -- i )
libX11 XDefaultScreen int (int) XDefaultScreen  ( dpy -- i )
libX11 XDoesBackingStore int (int) XDoesBackingStore       ( screen -- i )
libX11 XDoesSaveUnders int (int) XDoesSaveUnders ( screen -- flag )
libX11 XDisableAccessControl int (int) XDisableAccessControl   ( dpy -- r )
libX11 XEnableAccessControl int (int) XEnableAccessControl    ( dpy -- r )
libX11 XFlush int (void) XFlush  ( dpy -- r )
libX11 XFree int (int) XFree   ( data -- r )
libX11 XFreeExtensionList int (int) XFreeExtensionList      ( list -- r )
libX11 XFreeFontNames int (int) XFreeFontNames  ( list -- r )
libX11 XFreeFontPath int (int) XFreeFontPath   ( list -- r )
libX11 XFreeModifiermap int (int) XFreeModifiermap        ( modmap -- r )
libX11 XGrabServer int (int) XGrabServer     ( dpy -- r )
libX11 XHeightMMOfScreen int (int) XHeightMMOfScreen       ( screen -- n )
libX11 XHeightOfScreen int (int) XHeightOfScreen ( screen -- n )
libX11 XImageByteOrder int (int) XImageByteOrder ( dpy -- n )
libX11 XMaxCmapsOfScreen int (int) XMaxCmapsOfScreen       ( screen -- n )
libX11 XMinCmapsOfScreen int (int) XMinCmapsOfScreen       ( screen -- n )
libX11 XNoOp int (int) XNoOp   ( dpy -- r )
libX11 XPending int (int) XPending        ( dpy -- n )
libX11 XPlanesOfScreen int (int) XPlanesOfScreen ( screen -- n )
libX11 XProtocolRevision int (int) XProtocolRevision       ( dpy -- n )
libX11 XProtocolVersion int (int) XProtocolVersion        ( dpy -- n )
libX11 XQLength int (int) XQLength        ( dpy -- n )
libX11 XRefreshKeyboardMapping int (int) XRefreshKeyboardMapping ( event_map -- r )
libX11 XResetScreenSaver int (int) XResetScreenSaver       ( dpy -- r )
libX11 XScreenCount int (int) XScreenCount    ( dpy -- n )
libX11 XUngrabServer int (int) XUngrabServer   ( dpy -- r )
libX11 XVendorRelease int (int) XVendorRelease  ( dpy -- n )
libX11 XWidthMMOfScreen int (int) XWidthMMOfScreen        ( screen -- n )
libX11 XWidthOfScreen int (int) XWidthOfScreen  ( screen -- n )
libX11 XSetLocaleModifiers int (int) XSetLocaleModifiers     ( modifier_list -- string )
libX11 XCloseOM int (int) XCloseOM        ( om -- status )
libX11 XSetOMValues int (int) XSetOMValues    ( ...om -- string )
libX11 XGetOMValues int (int) XGetOMValues    ( ...om -- string )
libX11 XDisplayOfOM int (int) XDisplayOfOM    ( om -- dpy )
libX11 XLocaleOfOM int (int) XLocaleOfOM     ( om -- string )
libX11 XCreateOC int (int) XCreateOC       ( ...om -- XOC )
libX11 XDestroyOC int (int) XDestroyOC      ( oc -- r )
libX11 XOMOfOC int (int) XOMOfOC ( oc -- XOM )
libX11 XSetOCValues int (int) XSetOCValues    ( ...oc -- string )
libX11 XGetOCValues int (int) XGetOCValues    ( ...oc -- string )
libX11 XBaseFontNameListOfFontSet int (int) XBaseFontNameListOfFontSet       ( fontset -- string )
libX11 XLocaleOfFontSet int (int) XLocaleOfFontSet        ( fontset -- string )
libX11 XContextDependentDrawing int (int) XContextDependentDrawing        ( fontset -- flag )
libX11 XDirectionalDependentDrawing int (int) XDirectionalDependentDrawing    ( fontset -- flag )
libX11 XContextualDrawing int (int) XContextualDrawing      ( fontset -- flag )
libX11 XExtentsOfFontSet int (int) XExtentsOfFontSet       ( fontset -- fontsetextents )
libX11 XCloseIM int (int) XCloseIM        ( im -- status )
libX11 XDisplayOfIM int (int) XDisplayOfIM    ( im -- dpy )
libX11 XLocaleOfIM int (int) XLocaleOfIM     ( im -- string )
libX11 XCreateIC int (int) XCreateIC       ( im -- XIC )
libX11 XDestroyIC int (int) XDestroyIC      ( ic -- r )
libX11 XSetICFocus int (int) XSetICFocus     ( ic -- r )
libX11 XUnsetICFocus int (int) XUnsetICFocus   ( ic -- r )
libX11 XwcResetIC int (int) XwcResetIC      ( ic -- wstring )
libX11 XmbResetIC int (int) XmbResetIC      ( ic -- string )
libX11 XIMOfIC int (int) XIMOfIC ( ic -- XIM )
libX11 XDestroyRegion int (int) XDestroyRegion  ( reg -- r )
libX11 XEmptyRegion int (int) XEmptyRegion    ( reg -- r )
libX11 XwcFreeStringList int (int) XwcFreeStringList       ( list -- r )
libX11 Xpermalloc int (int) Xpermalloc      ( size -- addr )
libX11 XrmStringToQuark int (int) XrmStringToQuark        ( string -- quark )
libX11 XrmPermStringToQuark int (int) XrmPermStringToQuark    ( string -- quark )
libX11 XrmQuarkToString int (int) XrmQuarkToString        ( quark -- string )
libX11 XrmDestroyDatabase int (int) XrmDestroyDatabase      ( dbase -- r )
libX11 XrmGetDatabase int (int) XrmGetDatabase  ( dpy -- dbase )
libX11 XrmGetFileDatabase int (int) XrmGetFileDatabase      ( filename -- dbase )
libX11 XrmGetStringDatabase int (int) XrmGetStringDatabase    ( string -- dbase )
libX11 XrmLocaleOfDatabase int (int) XrmLocaleOfDatabase     ( dbase -- string )

libX11 XrmInitialize                 (int) XrmInitialize   ( -- r )
libX11 XInitThreads                  (int) XInitThreads    ( -- status )
libX11 XAllPlanes                    (int) XAllPlanes      ( -- u )
libX11 XAllocClassHint               (int) XAllocClassHint ( -- classhint* )
libX11 XAllocIconSize                (int) XAllocIconSize  ( -- iconsize* )
libX11 XAllocSizeHints               (int) XAllocSizeHints ( -- sizehints* )
libX11 XAllocStandardColormap        (int) XAllocStandardColormap  ( -- stdcmap* )
libX11 XAllocWMHints                 (int) XAllocWMHints   ( -- wmhints* )
libX11 XCreateRegion                 (int) XCreateRegion   ( -- reg )
libX11 XDefaultString                (int) XDefaultString  ( -- char* )
libX11 XrmUniqueQuark                (int) XrmUniqueQuark  ( -- quark )

libX11 XLoadQueryFont [ 2 ] ints (int) XLoadQueryFont  ( dpy name -- fontstruct )
libX11 XAllocColor [ 3 ] ints (int) XAllocColor     ( color colormap dpy -- status )
libX11 XGetWindowAttributes [ 3 ] ints (int) XGetWindowAttributes    ( dpy win windows_attributes_r -- status )
libX11 XChangeWindowAttributes [ 4 ] ints (int) XChangeWindowAttributes ( dpy win valuemask attributes -- r )
libX11 XGetErrorText [ 4 ] ints (int) XGetErrorText   ( dpy code buffer_r length -- r )
libX11 XSupportsLocale (int) XSupportsLocale ( -- flag )
libX11 XGetVisualInfo [ 4 ] ints (int) XGetVisualInfo  ( dpy vinfo_mask vinfo_templ nitems_r -- vinfo* )
libX11 XCreateColormap [ 4 ] ints (int) XCreateColormap ( dpy w visual alloc -- colormap )
libX11 XOpenIM [ 4 ] ints (int) XOpenIM ( dpy rdb res_name res_class -- XIM )
libX11 XGetIMValues_1 [ 4 ] ints (ptr) XGetIMValues    ( im ... -- string )
libX11 XGetIMValues_2 [ 6 ] ints (ptr) XGetIMValues    ( im ... -- string )
libX11 XGetIMValues_3 [ 8 ] ints (ptr) XGetIMValues  ( im ... -- string )
libX11 XSetIMValues_1 [ 4 ] ints (ptr) XSetIMValues    ( im ... -- string )
libX11 XSetIMValues_2 [ 6 ] ints (ptr) XSetIMValues    ( im ... -- string )
libX11 XSetIMValues_3 [ 8 ] ints (ptr) XSetIMValues    ( im ... -- string )
libX11 XVaCreateNestedList_1 [ 4 ] ints (ptr) XVaCreateNestedList     ( ...unused -- vanestedlist )
libX11 XVaCreateNestedList_2 [ 6 ] ints (ptr) XVaCreateNestedList     ( ...unused -- vanestedlist )
libX11 XVaCreateNestedList_3 [ 8 ] ints (ptr) XVaCreateNestedList     ( ...unused -- vanestedlist )
libX11 XVaCreateNestedList_4 [ &10 ] ints (ptr) XVaCreateNestedList     ( ...unused -- vanestedlist )
libX11 XCreateIC_1 [ 4 ] ints (ptr) XCreateIC       ( im -- XIC )
libX11 XCreateIC_2 [ 6 ] ints (ptr) XCreateIC       ( im -- XIC )
libX11 XCreateIC_3 [ 8 ] ints (ptr) XCreateIC       ( im -- XIC )
libX11 XCreateIC_4 [ &10 ] ints (ptr) XCreateIC       ( im -- XIC )
libX11 XCreateIC_5 [ &12 ] ints (ptr) XCreateIC       ( im -- XIC )
libX11 XCreateGC [ 4 ] ints (ptr) XCreateGC ( dpy d valuemask values -- gc )
libX11 XDestroyWindow [ 2 ] ints (int) XDestroyWindow  ( dpy win -- r )
libX11 XKeycodeToKeysym [ 3 ] ints (int) XKeycodeToKeysym        ( dpy keycode index -- keysym )
libX11 XCreateFontSet [ 5 ] ints (int) XCreateFontSet  ( dpy base_font_name_list missing_charset_list missing-charset_count def_string -- fontset )
libX11 XFreeColors [ 5 ] ints (int) XFreeColors     ( dpy colormap pixels npixels planes -- r )
libX11 XCreateFontCursor [ 2 ] ints (int) XCreateFontCursor       ( dpy shape -- cursor )
libX11 XChangeGC [ 4 ] ints (int) XChangeGC       ( dpy gc valuemask values -- r )
libX11 XSetFunction [ 3 ] ints (int) XSetFunction    ( dpy gc function -- r )
libX11 XStoreBytes [ 3 ] ints (int) XStoreBytes     ( dpy bytes nbytes -- r )
libX11 XSetSelectionOwner [ 4 ] ints (int) XSetSelectionOwner      ( dpy selection owner time -- r )
libX11 XChangeProperty [ 8 ] ints (int) XChangeProperty ( dpy w property type format mode data elements -- r )
libX11 XConvertSelection [ 6 ] ints (int) XConvertSelection       ( dpy selection target property requestor time -- r )
libX11 XGetSelectionOwner [ 2 ] ints (int) XGetSelectionOwner      ( dpy atom -- window )
libX11 XFetchBytes [ 2 ] ints (int) XFetchBytes     ( dpy nbytesr -- buffer )
libX11 XCreateWindow [ &12 ] ints (int) XCreateWindow   ( dpy parent x y w h borderwidth depth class visual valuemask attribs -- window )
libX11 XGetWindowProperty [ &12 ] ints (int) XGetWindowProperty      ( dpy w property offset length delete req_type actual_typer actual_format_r nitems_r bytes_after_r prop_r -- n )
libX11 XDefineCursor [ 3 ] ints (int) XDefineCursor   ( dpy win cursor -- r )
libX11 XSetLineAttributes [ 6 ] ints (int) XSetLineAttributes      ( dpy gc line_width line_style cap_style join_style -- r )
libX11 XDrawLine [ 7 ] ints (void) XDrawLine       ( dpy d gc x1 x2 y1 y2 -- )
libX11 XFillRectangle [ 7 ] ints (void) XFillRectangle  ( dpy d gc x y w h -- )
libX11 XFillPolygon [ 7 ] ints (void) XFillPolygon    ( dpy d gc points npoints shape mode -- )
libX11 XDrawLines [ 6 ] ints (void) XDrawLines      ( dpy d gc points npoints mode -- )
libX11 XSetClipMask [ 3 ] ints (void) XSetClipMask    ( dpy gc pixmap -- )
libX11 XSetClipOrigin [ 4 ] ints (void) XSetClipOrigin  ( dpy gc clip_x_orig clip_y_orig -- )
libX11 XCopyArea [ &10 ] ints (void) XCopyArea       ( dpy src dest gc x y w h dx dy -- )
libX11 XUnionRectWithRegion [ 3 ] ints (void) XUnionRectWithRegion    ( rect src_reg dest_reg_r -- )
libX11 XSetRegion [ 3 ] ints (void) XSetRegion      ( dpy gc reg -- )
libX11 XCheckMaskEvent [ 3 ] ints (int) XCheckMaskEvent ( dpy event_mask event_r -- flag )
libX11 XNextEvent [ 2 ] ints (void) XNextEvent      ( dpy event_r -- )
libX11 XSync [ 2 ] ints (void) XSync   ( dpy discard -- )
libX11 XQueryPointer [ 9 ] ints (int) XQueryPointer   ( dpy w root_r child_r root_x_r root_y_r win_x_r win_y_r mask_r -- flag )
libX11 XLookupString [ 5 ] ints (int) XLookupString   ( event buffer bufsize keysym_r composestatus* -- n )
libX11 XGetAtomName [ 2 ] ints (int) XGetAtomName    ( dpy atom -- name )
libX11 XSendEvent [ 5 ] ints (int) XSendEvent      ( dpy w propagate event_mask event_send -- status )
libX11 XTextExtents [ 7 ] ints (void) XTextExtents    ( font_struct string nchars direction_r font_ascent_r font_descent_r overall_r -- )
libX11 XTextExtents16 [ 7 ] ints (void) XTextExtents16    ( font_struct string nchars direction_r font_ascent_r font_descent_r overall_r -- )
libX11 XDrawText [ 7 ] ints (void) XDrawText       ( dpy d gc x y items nitems -- )
libX11 XDrawText16 [ 7 ] ints (void) XDrawText16       ( dpy d gc x y items nitems -- )
libX11 XFreePixmap [ 2 ] ints (void) XFreePixmap     ( dpy pixmap -- )
libX11 XCreatePixmap [ 5 ] ints (int) XCreatePixmap   ( dpy d w h depth -- pixmap )
libX11 XCreateImage [ &10 ] ints (ptr) XCreateImage    ( dpy visual depth format offset data w h bmpad b/line -- image )
libX11 XGetImage [ 8 ] ints (ptr) XGetImage       ( dpy d x y w h planemask format -- image )
libX11 XInternAtom [ 3 ] ints (int) XInternAtom     ( dpy atomname flag -- atom )
libX11 XListPixmapFormats [ 2 ] ints (int) XListPixmapFormats      ( dpy count_r -- pixmapformatvalues )
libX11 XSetTransientForHint [ 3 ] ints (void) XSetTransientForHint    ( dpy w propw -- )
libX11 XCopyPlane [ &11 ] ints (void) XCopyPlane      ( dpy src dest gc x y w h dx dy plane -- )
libX11 XFreeColormap [ 2 ] ints (void) XFreeColormap   ( dpy colormap -- )
libX11 XFreeGC [ 2 ] ints (void) XFreeGC ( dpy gc -- )
libX11 XGetGeometry [ 9 ] ints (int) XGetGeometry    ( dpy d root_r x_r y_r w_r h_r borderw_r depth_r -- status )
libX11 XGrabPointer [ 9 ] ints (int) XGrabPointer    ( time cursor confine_to keyboard_mode pointer_mode owner_events grab_window dpy -- n )
libX11 XMapRaised [ 2 ] ints (void) XMapRaised      ( dpy w -- )
libX11 XMapWindow [ 2 ] ints (void) XMapWindow      ( dpy w -- o)
libX11 XMoveResizeWindow [ 6 ] ints (void) XMoveResizeWindow       ( dpy win x y w h -- r )
libX11 XMoveWindow [ 4 ] ints (void) XMoveWindow     ( dpy win x y -- )
libX11 XParseGeometry [ 5 ] ints (int) XParseGeometry  ( parsestring x_r y_r w_r h_r -- n )
libX11 XPutImage [ &10 ] ints (void) XPutImage       ( dpy d gc image s_x s_y d_x d_y w h -- )
libX11 XResizeWindow [ 4 ] ints (void) XResizeWindow   ( dpy win w h -- )
libX11 XSetBackground [ 3 ] ints (void) XSetBackground  ( dpy gc background -- )
libX11 XSetForeground [ 3 ] ints (void) XSetForeground  ( dpy gc fg -- )
libX11 XSetIconName [ 3 ] ints (void) XSetIconName    ( dpy win icon_name -- )
libX11 XSetInputFocus [ 4 ] ints (void) XSetInputFocus  ( dpy focus revert_to time -- )
libX11 XStoreName [ 3 ] ints (void) XStoreName      ( dpy win window_name -- )
libX11 XUngrabPointer [ 2 ] ints (void) XUngrabPointer  ( dpy time -- )
libX11 XUnmapWindow [ 2 ] ints (void) XUnmapWindow    ( dpy w -- )
libX11 XWarpPointer [ 9 ] ints (void) XWarpPointer    ( dpy src_w dest_w src_x src_y src_w src_h dest_x dest_y -- )
libX11 XSelectInput [ 3 ] ints (void) XSelectInput    ( dpy w event_mask -- )
libX11 XWindowEvent [ 4 ] ints (void) XWindowEvent    ( dpy w event_mask event_r -- )
libX11 XSetICValues_1 [ 4 ] ints (int) XSetICValues    ( ic ... -- string )
libX11 XSetICValues_2 [ 6 ] ints (int) XSetICValues    ( ic ... -- string )
libX11 XSetICValues_3 [ 8 ] ints (int) XSetICValues    ( ic ... -- string )
libX11 XFilterEvent [ 2 ] ints (int) XFilterEvent    ( event w -- flag )
libX11 XIntersectRegion [ 3 ] ints (void) XIntersectRegion        ( sra srb dr_r -- )
libX11 XSetClassHint [ 3 ] ints (void) XSetClassHint   ( dpy w class_hints -- )
libX11 XSetTextProperty [ 4 ] ints (void) XSetTextProperty        ( dpy w text_prop prop -- )
libX11 XSetWMHints [ 3 ] ints (void) XSetWMHints     ( dpy w wm_hints -- )
libX11 XSetWMNormalHints [ 3 ] ints (void) XSetWMNormalHints       ( dpy w hints -- )
libX11 XCreateSimpleWindow [ 9 ] ints (int) XCreateSimpleWindow     ( dpy parent x y w h bwidth border bg -- window )

\ Unused stuff, machine converted

\ -1 libX11 _XPrivDisplay               _XPrivDisplay   ( -- addr )
\ -1 libX11 _Xdebug                       _Xdebug         ( -- addr )
libX11 XQueryFont [ 2 ] ints (int) XQueryFont      ( XID dpy -- fontstruct )
libX11 XGetMotionEvents [ 5 ] ints (int) XGetMotionEvents        ( neventsr stop start w dpy -- timecoord )
libX11 XDeleteModifiermapEntry [ 3 ] ints (int) XDeleteModifiermapEntry ( mod keycode modmap -- modmap )
libX11 XInsertModifiermapEntry [ 3 ] ints (int) XInsertModifiermapEntry ( mod keycode modmap -- modmap )
libX11 XGetSubImage [ &11 ] ints (int) XGetSubImage    ( dy dx dimage format planemask h w y x d dpy -- image )
libX11 XFetchBuffer [ 3 ] ints (int) XFetchBuffer    ( buffer nbytesr dpy -- buffer )
libX11 XGetAtomNames [ 4 ] ints (int) XGetAtomNames   ( namesr count atoms dpy -- status )
libX11 XGetDefault [ 3 ] ints (int) XGetDefault     ( option program dpy --  string )
libX11 XInternAtoms [ 5 ] ints (int) XInternAtoms    ( atoms flag count names dpy -- status )
libX11 XCopyColormapAndFree [ 2 ] ints (int) XCopyColormapAndFree    ( colormap dpy -- colormap )
libX11 XCreatePixmapCursor [ 7 ] ints (int) XCreatePixmapCursor     ( y x bgcol fgcol mask source dpy -- cursor )
libX11 XCreateGlyphCursor [ 7 ] ints (int) XCreateGlyphCursor      ( bgcol fgcol maskc sourcec maskfont sourcefont dpy -- cursor )
libX11 XLoadFont [ 2 ] ints (int) XLoadFont       ( name dpy -- font )
libX11 XFlushGC [ 2 ] ints (int) XFlushGC        ( gc dpy -- r )
libX11 XCreateBitmapFromData [ 5 ] ints (int) XCreateBitmapFromData   ( h w data d dpy -- pixmap )
libX11 XCreatePixmapFromBitmapData [ 8 ] ints (int) XCreatePixmapFromBitmapData     ( depth bg fg h w data d dpy -- pixmap )
libX11 XListInstalledColormaps [ 3 ] ints (int) XListInstalledColormaps ( num_r w dpy -- colormap* )
libX11 XListFonts [ 4 ] ints (int) XListFonts      ( actual_count_r maxnames pattern dpy -- char** )
libX11 XListFontsWithInfo [ 5 ] ints (int) XListFontsWithInfo      ( info_r count_r maxnames pattern dpy -- char** )
libX11 XGetFontPath [ 2 ] ints (int) XGetFontPath    ( npaths_r dpy -- char** )
libX11 XListExtensions [ 2 ] ints (int) XListExtensions ( nextensions_r dpy -- char** )
libX11 XListProperties [ 3 ] ints (int) XListProperties ( num_prop_r w dpy -- atom* )
libX11 XListHosts [ 3 ] ints (int) XListHosts      ( status_r nhosts_r dpy -- hostaddr* )
libX11 XLookupKeysym [ 2 ] ints (int) XLookupKeysym   ( index key_event -- keysym )
libX11 XGetKeyboardMapping [ 4 ] ints (int) XGetKeyboardMapping     ( keysym/keycode_r keycode_c first_kc dpy -- keysym* )
libX11 XInitExtension [ 2 ] ints (int) XInitExtension  ( name dpy -- extcodes )
libX11 XFindOnExtensionList [ 2 ] ints (int) XFindOnExtensionList    ( number structure -- extdata )
libX11 XRootWindow [ 2 ] ints (int) XRootWindow     ( screen_nr dpy -- window )
libX11 XDefaultVisual [ 2 ] ints (int) XDefaultVisual  ( screen_nr dpy -- visual )
libX11 XDefaultGC [ 2 ] ints (int) XDefaultGC      ( screen_nr dpy -- gc )
libX11 XBlackPixel [ 2 ] ints (int) XBlackPixel     ( screen_nr dpy -- u )
libX11 XWhitePixel [ 2 ] ints (int) XWhitePixel     ( screen_nr dpy -- u )
libX11 XDefaultColormap [ 2 ] ints (int) XDefaultColormap        ( screen_nr dpy -- colormap )
libX11 XScreenOfDisplay [ 2 ] ints (int) XScreenOfDisplay        ( screen_nr dpy -- screen )
libX11 XListDepths [ 3 ] ints (int) XListDepths     ( count_r screen_nr dpy -- int* )
libX11 XReconfigureWMWindow [ 5 ] ints (int) XReconfigureWMWindow    ( changes mask screen_nr w dpy -- status )
libX11 XGetWMProtocols [ 4 ] ints (int) XGetWMProtocols ( count_r protocols_r w dpy -- status )
libX11 XSetWMProtocols [ 4 ] ints (int) XSetWMProtocols ( count protocols w dpy -- status )
libX11 XIconifyWindow [ 3 ] ints (int) XIconifyWindow  ( screen_nr w dpy -- status )
libX11 XWithdrawWindow [ 3 ] ints (int) XWithdrawWindow ( screen_nr w dpy -- status )
libX11 XGetCommand [ 4 ] ints (int) XGetCommand     ( argc_r argv_r w dpy -- status )
libX11 XGetWMColormapWindows [ 4 ] ints (int) XGetWMColormapWindows   ( count_r windows_r w dpy -- status )
libX11 XSetWMColormapWindows [ 4 ] ints (int) XSetWMColormapWindows   ( count colormap_windows w dpy -- status )
libX11 XAddHost [ 2 ] ints (int) XAddHost        ( host dpy -- r )
libX11 XAddHosts [ 3 ] ints (int) XAddHosts       ( num hosts dpy -- r )
libX11 XAddToExtensionList [ 2 ] ints (int) XAddToExtensionList     ( extdata structure -- r )
libX11 XAddToSaveSet [ 2 ] ints (int) XAddToSaveSet   ( w dpy -- r )
libX11 XAllocColorCells [ 7 ] ints (int) XAllocColorCells        ( pixels pixels_r planes planemask_r contig colormap dpy -- status )
libX11 XAllocColorPlanes [ &11 ] ints (int) XAllocColorPlanes       ( bmask_r gmask_r rmask_r blues greens reds colors pixels_r contig colormap dpy -- status )
libX11 XAllocNamedColor [ 5 ] ints (int) XAllocNamedColor        ( exact_def_r screen_def_r cname colormap dpy -- status )
libX11 XAllowEvents [ 3 ] ints (int) XAllowEvents    ( time event_mode dpy -- r )
libX11 XBell [ 2 ] ints (int) XBell   ( percent dpy -- r )
libX11 XChangeActivePointerGrab [ 4 ] ints (int) XChangeActivePointerGrab        ( time cursor event_mask dpy -- r )
libX11 XChangeKeyboardControl [ 3 ] ints (int) XChangeKeyboardControl  ( values valuemask dpy -- r )
libX11 XChangeKeyboardMapping [ 5 ] ints (int) XChangeKeyboardMapping  ( num_codes keysyms keysyms/keycode first_kc dpy -- r )
libX11 XChangePointerControl [ 6 ] ints (int) XChangePointerControl   ( threshold accel_denom accel_num do_thres do_accel dpy -- r )
libX11 XChangeSaveSet [ 3 ] ints (int) XChangeSaveSet  ( change_mode w dpy -- r )
libX11 XCheckIfEvent [ 4 ] ints (int) XCheckIfEvent   ( arg predicate event_return dpy -- flag )
libX11 XCheckTypedEvent [ 3 ] ints (int) XCheckTypedEvent        ( event_r event_type dpy -- flag )
libX11 XCheckTypedWindowEvent [ 4 ] ints (int) XCheckTypedWindowEvent  ( event_r event_type w dpy -- flag )
libX11 XCheckWindowEvent [ 4 ] ints (int) XCheckWindowEvent       ( event_r event_mask w dpy -- flag )
libX11 XCirculateSubwindows [ 3 ] ints (int) XCirculateSubwindows    ( direction w dpy -- r )
libX11 XCirculateSubwindowsDown [ 2 ] ints (int) XCirculateSubwindowsDown        ( w dpy -- r )
libX11 XCirculateSubwindowsUp [ 2 ] ints (int) XCirculateSubwindowsUp  ( w dpy -- r )
libX11 XClearArea [ 7 ] ints (int) XClearArea      ( exposures h w y x w dpy -- r )
libX11 XClearWindow [ 2 ] ints (int) XClearWindow    ( w dpy -- r )
libX11 XConfigureWindow [ 4 ] ints (int) XConfigureWindow        ( values value_mask w dpy -- r )
libX11 XCopyGC [ 4 ] ints (int) XCopyGC ( dest valuemask src dpy -- r )
libX11 XDefaultDepth [ 2 ] ints (int) XDefaultDepth   ( screen_nr dpy -- i )
libX11 XDeleteProperty [ 3 ] ints (int) XDeleteProperty ( atom w dpy -- r )
libX11 XDestroySubwindows [ 2 ] ints (int) XDestroySubwindows      ( w dpy -- r )
libX11 XDisplayCells [ 2 ] ints (int) XDisplayCells   ( screen_nr dpy -- i )
libX11 XDisplayHeight [ 2 ] ints (int) XDisplayHeight  ( screen_nr dpy -- i )
libX11 XDisplayHeightMM [ 2 ] ints (int) XDisplayHeightMM        ( screen_nr dpy -- i )
libX11 XDisplayKeycodes [ 3 ] ints (int) XDisplayKeycodes        ( min_keycodes_r max_keycodes_r dpy -- r )
libX11 XDisplayPlanes [ 2 ] ints (int) XDisplayPlanes  ( screen_nr dpy -- i )
libX11 XDisplayWidth [ 2 ] ints (int) XDisplayWidth   ( screen_nr dpy -- i )
libX11 XDisplayWidthMM [ 2 ] ints (int) XDisplayWidthMM ( screen_nr dpy -- i )
libX11 XDrawArc [ 9 ] ints (int) XDrawArc        ( angle2 angle1 h w y x gc d dpy -- r )
libX11 XDrawArcs [ 5 ] ints (int) XDrawArcs       ( narcs arcs gc d dpy -- r )
libX11 XDrawImageString [ 7 ] ints (int) XDrawImageString        ( length string y x gc d dpy -- r )
libX11 XDrawImageString16 [ 7 ] ints (int) XDrawImageString16      ( length string y x gc d dpy -- r )
[IFDEF] has-utf8
libX11 Xutf8DrawImageString [ 8 ] ints (int) Xutf8DrawImageString        ( dpy d fontset gc x y string length -- r )
libX11 Xutf8DrawString [ 8 ] ints (int) Xutf8DrawString     ( dpy d fontset gc x y string length -- r )
libX11 Xutf8LookupString [ 6 ] ints (int) Xutf8LookupString ( ic event buffer_r wchars_buffer keysym_r status_r -- n )
\ libX11 Xutf8TextExtents [ 7 ] ints (void) Xutf8TextExtents    ( font_struct string nchars direction_r font_ascent_r font_descent_r overall_r -- )
libX11 Xutf8DrawText [ 7 ] ints (void) Xutf8DrawText       ( dpy d gc x y items nitems -- )
libX11 Xutf8TextEscapement [ 3 ] ints (int) Xutf8TextEscapement       ( num_wchars text fontset -- n )
libX11 Xutf8TextPerCharExtents [ 9 ] ints (int) Xutf8TextPerCharExtents   ( overal_logical_r overall_ink_r num_chars buffer_size logical_extents_buffer ink_extents_buffer num_wchars text fontset -- status )
libX11 Xutf8ResetIC int (int) Xutf8ResetIC      ( ic -- string )
[THEN]
libX11 XDrawPoint [ 5 ] ints (int) XDrawPoint      ( y x gc d dpy -- r )
libX11 XDrawPoints [ 6 ] ints (int) XDrawPoints     ( mode npoints point gc d dpy -- r )
libX11 XDrawRectangle [ 7 ] ints (int) XDrawRectangle  ( h w y x gc d dpy -- r )
libX11 XDrawRectangles [ 5 ] ints (int) XDrawRectangles ( nrects rects gc d dpy -- r )
libX11 XDrawSegments [ 5 ] ints (int) XDrawSegments   ( nsegments segments gc d dpy -- r )
libX11 XDrawString [ 7 ] ints (int) XDrawString     ( length string y x gc d dpy -- r )
libX11 XDrawString16 [ 7 ] ints (int) XDrawString16   ( length string y x gc d dpy -- r )
libX11 XEventsQueued [ 2 ] ints (int) XEventsQueued   ( mode dpy -- i )
libX11 XFetchName [ 3 ] ints (int) XFetchName      ( name_r w dpy -- status )
libX11 XFillArc [ 9 ] ints (int) XFillArc        ( angle2 angle1 h w y x gc d dpy -- r )
libX11 XFillArcs [ 5 ] ints (int) XFillArcs       ( narcs arcs gc d dpy -- r )
libX11 XFillRectangles [ 5 ] ints (int) XFillRectangles ( nrects rects gc d dpy -- r )
libX11 XForceScreenSaver [ 2 ] ints (int) XForceScreenSaver       ( mode dpy -- r )
libX11 XFreeCursor [ 2 ] ints (int) XFreeCursor     ( cursor dpy -- r )
libX11 XFreeFont [ 2 ] ints (int) XFreeFont       ( fontstruct dpy -- r )
libX11 XFreeFontInfo [ 3 ] ints (int) XFreeFontInfo   ( actual_count free_info names -- r )
libX11 XGeometry [ &13 ] ints (int) XGeometry       ( hr wr yr xr yadder xadder fh fw bw default_pos pos screen dpy -- n )
libX11 XGetErrorDatabaseText [ 6 ] ints (int) XGetErrorDatabaseText   ( int buffer_r default_string message name dpy -- r )
libX11 XGetFontProperty [ 3 ] ints (int) XGetFontProperty        ( value_r atom fontstruct -- flag )
libX11 XGetGCValues [ 4 ] ints (int) XGetGCValues    ( values_r valuemask gc dpy -- status )
libX11 XGetIconName [ 3 ] ints (int) XGetIconName    ( icon_name-r w dpy -- status )
libX11 XGetInputFocus [ 3 ] ints (int) XGetInputFocus  ( revert_to_r focus_r dpy -- r )
libX11 XGetKeyboardControl [ 2 ] ints (int) XGetKeyboardControl     ( values_r dpy -- r )
libX11 XGetPointerControl [ 4 ] ints (int) XGetPointerControl      ( threshold_r accel_denom_r accel_num_r dpy -- r )
libX11 XGetPointerMapping [ 3 ] ints (int) XGetPointerMapping      ( nmap map_r dpy -- n )
libX11 XGetScreenSaver [ 5 ] ints (int) XGetScreenSaver ( allow_exposures_r prefer_blanking_r interval_r timeout_r dpy -- r )
libX11 XGetTransientForHint [ 3 ] ints (int) XGetTransientForHint    ( prop_w_r w dpy -- status )
libX11 XGrabButton [ 9 ] ints (int) XGrabButton     ( cursor confine_to keyboard_mode pointer_mode owner_events grab_window modifiers button dpy -- r )
libX11 XGrabKey [ 8 ] ints (int) XGrabKey        ( keyboard_mode pointer_mode owner_events grab_events grab_window modifiers keycode dpy -- r )
libX11 XGrabKeyboard [ 6 ] ints (int) XGrabKeyboard   ( time keyboard_mode pointer_mode owner_events grab_window dpy -- n )
libX11 XIfEvent [ 4 ] ints (int) XIfEvent        ( arg predicate event_r dpy -- r )
libX11 XInstallColormap [ 2 ] ints (int) XInstallColormap        ( colormap dpy -- r )
libX11 XKeysymToKeycode [ 2 ] ints (int) XKeysymToKeycode        ( keysym dpy -- keycode )
libX11 XKillClient [ 2 ] ints (int) XKillClient     ( resource dpy -- r )
\ 1 libX11 XLastKnownRequestProcessed   XLastKnownRequestProcessed      ( dpy -- u )
libX11 XLookupColor [ 5 ] ints (int) XLookupColor    ( screen_def_r exact_def_r color_name colormap dpy -- status )
libX11 XLowerWindow [ 2 ] ints (int) XLowerWindow    ( w dpy -- r )
libX11 XMapSubwindows [ 2 ] ints (int) XMapSubwindows  ( w dpy -- r )
libX11 XMaskEvent [ 3 ] ints (int) XMaskEvent      ( event_r event_mask dpy -- r )
libX11 XParseColor [ 4 ] ints (int) XParseColor     ( exact_def_r spec colormap dpy -- status )
libX11 XPeekEvent [ 2 ] ints (int) XPeekEvent      ( event_r dpy -- r )
libX11 XPeekIfEvent [ 4 ] ints (int) XPeekIfEvent    ( arg predicate event_r dpy -- r )
libX11 XPutBackEvent [ 2 ] ints (int) XPutBackEvent   ( event dpy -- r )
libX11 XQueryBestCursor [ 6 ] ints (int) XQueryBestCursor        ( h_r w_r h w d dpy -- status )
libX11 XQueryBestSize [ 7 ] ints (int) XQueryBestSize  ( h_r w_r h w which_screen class dpy -- status )
libX11 XQueryBestStipple [ 6 ] ints (int) XQueryBestStipple       ( h_r w_r h w which_screen dpy -- status )
libX11 XQueryBestTile [ 6 ] ints (int) XQueryBestTile  ( h_r w_r h w which_screen dpy -- status )
libX11 XQueryColor [ 3 ] ints (int) XQueryColor     ( def_in_out colormap dpy -- r )
libX11 XQueryColors [ 4 ] ints (int) XQueryColors    ( ncolors defs_in_out colormap dpy -- r )
libX11 XQueryExtension [ 5 ] ints (int) XQueryExtension ( first_error_r first_event_r major_opcode_r name dpy -- flag )
libX11 XQueryKeymap [ 2 ] ints (int) XQueryKeymap    ( keys_r dpy -- r )
libX11 XQueryTextExtents [ 8 ] ints (int) XQueryTextExtents       ( overall_r font_descent_r font_ascent_r direction_r nchars string font_id dpy -- r )
libX11 XQueryTextExtents16 [ 8 ] ints (int) XQueryTextExtents16     ( overall_r font_descent_r font_ascent_r direction_r nchars string font_id dpy -- r )
libX11 XQueryTree [ 6 ] ints (int) XQueryTree      ( nchildren_r children_r parent_r root_r w dpy -- status )
libX11 XRaiseWindow [ 2 ] ints (int) XRaiseWindow    ( w dpy -- r )
libX11 XReadBitmapFile [ 8 ] ints (int) XReadBitmapFile ( y_hot_r x_hot_r bitmap_r height_r width_r filename d dpy -- n )
libX11 XReadBitmapFileData [ 6 ] ints (int) XReadBitmapFileData     ( y_hot_r x_hot_r bitmap_r height_r width_r filename -- n )
libX11 XRebindKeysym [ 6 ] ints (int) XRebindKeysym   ( bytes_string string mod_count list keysym dpy -- r )
libX11 XRecolorCursor [ 4 ] ints (int) XRecolorCursor  ( bg fg cursor dpy -- r )
libX11 XRemoveFromSaveSet [ 2 ] ints (int) XRemoveFromSaveSet      ( w dpy -- r )
libX11 XRemoveHost [ 2 ] ints (int) XRemoveHost     ( host dpy -- r )
libX11 XRemoveHosts [ 3 ] ints (int) XRemoveHosts    ( num_hosts hosts dpy -- r )
libX11 XReparentWindow [ 5 ] ints (int) XReparentWindow ( y x parent w dpy -- r )
libX11 XRestackWindows [ 3 ] ints (int) XRestackWindows ( nwindows windows dpy -- r )
libX11 XRotateBuffers [ 2 ] ints (int) XRotateBuffers  ( rotate dpy -- r )
libX11 XRotateWindowProperties [ 5 ] ints (int) XRotateWindowProperties ( npositions num_prop properties w dpy -- r )
libX11 XSetAccessControl [ 2 ] ints (int) XSetAccessControl       ( mode dpy -- r )
libX11 XSetArcMode [ 3 ] ints (int) XSetArcMode     ( arc_mode gc dpy -- r )
libX11 XSetClipRectangles [ 7 ] ints (int) XSetClipRectangles      ( ordering n rectangles clip_y_orig clip_x_orig gc dpy -- r )
libX11 XSetCloseDownMode [ 2 ] ints (int) XSetCloseDownMode       ( close_mode dpy -- r )
libX11 XSetCommand [ 4 ] ints (int) XSetCommand     ( argc argv w dpy -- r )
libX11 XSetDashes [ 5 ] ints (int) XSetDashes      ( n dash_list dash_ofset gc dpy -- r )
libX11 XSetFillRule [ 3 ] ints (int) XSetFillRule    ( fill_rule gc dpy -- r )
libX11 XSetFillStyle [ 3 ] ints (int) XSetFillStyle   ( fill_style gc dpy -- r )
libX11 XSetFont [ 3 ] ints (int) XSetFont        ( font gc dpy -- r )
libX11 XSetFontPath [ 3 ] ints (int) XSetFontPath    ( ndirs directories dpy -- r )
libX11 XSetGraphicsExposures [ 3 ] ints (int) XSetGraphicsExposures   ( graphics_exposures gc dpy -- r )
libX11 XSetModifierMapping [ 2 ] ints (int) XSetModifierMapping     ( modmap dpy -- n )
libX11 XSetPlaneMask [ 3 ] ints (int) XSetPlaneMask   ( plane_mask gc dpy -- r )
libX11 XSetPointerMapping [ 3 ] ints (int) XSetPointerMapping      ( nmap map dpy -- n )
libX11 XSetScreenSaver [ 5 ] ints (int) XSetScreenSaver ( allow_exposures prefer_blanking interval timeout dpy -- r )
libX11 XSetState [ 6 ] ints (int) XSetState       ( plane_mask function bg fg gc dpy -- r )
libX11 XSetStipple [ 3 ] ints (int) XSetStipple     ( stripple gc dpy -- r )
libX11 XSetSubwindowMode [ 3 ] ints (int) XSetSubwindowMode       ( subwindow_mode gc dpy -- r )
libX11 XSetTSOrigin [ 4 ] ints (int) XSetTSOrigin    ( ts_y_orig ts_x_orig gc dpy -- r )
libX11 XSetTile [ 3 ] ints (int) XSetTile        ( tile gc dpy -- )
libX11 XSetWindowBackground [ 3 ] ints (int) XSetWindowBackground    ( bg_pixel w dpy -- )
libX11 XSetWindowBackgroundPixmap [ 3 ] ints (int) XSetWindowBackgroundPixmap      ( bg_pixmap w dpy -- r )
libX11 XSetWindowBorder [ 3 ] ints (int) XSetWindowBorder        ( border_pixel w dpy -- r )
libX11 XSetWindowBorderPixmap [ 3 ] ints (int) XSetWindowBorderPixmap  ( border_pixmap w dpy -- r )
libX11 XSetWindowBorderWidth [ 3 ] ints (int) XSetWindowBorderWidth   ( width w dpy -- r )
libX11 XSetWindowColormap [ 3 ] ints (int) XSetWindowColormap      ( colormap w dpy -- r )
libX11 XStoreBuffer [ 4 ] ints (int) XStoreBuffer    ( buffer nbytes bytes dpy -- r )
libX11 XStoreColor [ 3 ] ints (int) XStoreColor     ( color colormap dpy -- r )
libX11 XStoreColors [ 4 ] ints (int) XStoreColors    ( ncolors color colormap dpy -- r )
libX11 XStoreNamedColor [ 5 ] ints (int) XStoreNamedColor        ( flags pixel color colormap dpy -- r )
libX11 XTextWidth [ 3 ] ints (int) XTextWidth      ( count string font_struct -- n )
libX11 XTextWidth16 [ 3 ] ints (int) XTextWidth16    ( count string font_struct -- n )
libX11 XTranslateCoordinates [ 8 ] ints (int) XTranslateCoordinates   ( child_r dest_y_r dest_x_r src_y src_x dest_w src_w dpy -- flag )
libX11 XUndefineCursor [ 2 ] ints (int) XUndefineCursor ( w dpy -- r )
libX11 XUngrabButton [ 4 ] ints (int) XUngrabButton   ( grab_window modifiers button dpy -- r )
libX11 XUngrabKey [ 4 ] ints (int) XUngrabKey      ( grab_window modifiers keycode dpy -- r )
libX11 XUngrabKeyboard [ 2 ] ints (int) XUngrabKeyboard ( time dpy -- r )
libX11 XUninstallColormap [ 2 ] ints (int) XUninstallColormap      ( colormap dpy -- r )
libX11 XUnloadFont [ 2 ] ints (int) XUnloadFont     ( font dpy -- r )
libX11 XUnmapSubwindows [ 2 ] ints (int) XUnmapSubwindows        ( w dpy -- r )
libX11 XWriteBitmapFile [ 7 ] ints (int) XWriteBitmapFile        ( y_hot x_hot h w bitmap filename dpy -- r )
libX11 XOpenOM [ 4 ] ints (int) XOpenOM ( res_class res_name rdb dpy -- XOM )
libX11 XFreeFontSet [ 2 ] ints (int) XFreeFontSet    ( fontset dpy -- r )
libX11 XFontsOfFontSet [ 3 ] ints (int) XFontsOfFontSet ( font_name_list font_struct_list font_set -- n )
libX11 XmbTextEscapement [ 3 ] ints (int) XmbTextEscapement       ( bytes_text text fontset -- n )
libX11 XwcTextEscapement [ 3 ] ints (int) XwcTextEscapement       ( num_wchars text fontset -- n )
libX11 XmbTextExtents [ 5 ] ints (int) XmbTextExtents  ( overall_logical_r overall_ink_r bytes_text text fontset -- n )
libX11 XwcTextExtents [ 5 ] ints (int) XwcTextExtents  ( overall_logical_r overall_ink_r num_wchars text fontset -- n )
libX11 XmbTextPerCharExtents [ 9 ] ints (int) XmbTextPerCharExtents   ( overal_logical_r overall_ink_r num_chars buffer_size logical_extents_buffer ink_extents_buffer bytes_text text fontset -- status )
libX11 XwcTextPerCharExtents [ 9 ] ints (int) XwcTextPerCharExtents   ( overal_logical_r overall_ink_r num_chars buffer_size logical_extents_buffer ink_extents_buffer num_wchars text fontset -- status )
libX11 XmbDrawText [ 7 ] ints (int) XmbDrawText     ( nitems text_items y x gc d dpy -- r )
libX11 XwcDrawText [ 7 ] ints (int) XwcDrawText     ( nitems text_items y x gc d dpy -- r )
libX11 XmbDrawString [ 8 ] ints (int) XmbDrawString   ( bytes_text text y x gc fontset d dpy -- r )
libX11 XwcDrawString [ 8 ] ints (int) XwcDrawString   ( num_wchars text y x gc fontset d dpy -- r )
libX11 XmbDrawImageString [ 8 ] ints (int) XmbDrawImageString      ( bytes_text text y x gc fontset d dpy -- r )
libX11 XwcDrawImageString [ 8 ] ints (int) XwcDrawImageString      ( num_wchars text y x gc fontset d dpy -- r )
libX11 XGetICValues_1 [ 4 ] ints (int) XGetICValues    ( ... ic -- string )
libX11 XGetICValues_2 [ 6 ] ints (int) XGetICValues    ( ... ic -- string )
libX11 XGetICValues_3 [ 8 ] ints (int) XGetICValues    ( ... ic -- string )
libX11 XmbLookupString [ 6 ] ints (int) XmbLookupString ( status_r keysym_r bytes_buffer buffer_r event ic -- n )
libX11 XwcLookupString [ 6 ] ints (int) XwcLookupString ( status_r keysym_r wchars_buffer buffer_r event ic -- n )
libX11 XRegisterIMInstantiateCallback [ 6 ] ints (int) XRegisterIMInstantiateCallback  ( client_data callback res_class res_name rdb dpy -- flag )
libX11 XUnregisterIMInstantiateCallbac [ 6 ] ints (int) XUnregisterIMInstantiateCallback        ( client_data callback res_class res_name rdb dpy -- flag )
libX11 XInternalConnectionNumbers [ 3 ] ints (int) XInternalConnectionNumbers      ( count_r fd_r dpy -- status )
libX11 XProcessInternalConnection [ 2 ] ints (int) XProcessInternalConnection      ( fd dpy -- r )
libX11 XAddConnectionWatch [ 3 ] ints (int) XAddConnectionWatch     ( client_data callback dpy -- status )
libX11 XRemoveConnectionWatch [ 3 ] ints (int) XRemoveConnectionWatch  ( client_data callback dpy -- status )

\ Xutil.h
\ The following functions are not performed by the XServer, but in Xlib.

libX11 XClipBox [ 2 ] ints (int) XClipBox        ( rect reg -- r )
libX11 XDeleteContext [ 3 ] ints (int) XDeleteContext  ( context rid dpy -- n )
libX11 XEqualRegion [ 2 ] ints (int) XEqualRegion    ( r1 r2 -- r )
libX11 XFindContext [ 4 ] ints (int) XFindContext    ( data_r context rid dpy -- n )
libX11 XGetClassHint [ 3 ] ints (int) XGetClassHint   ( class_hints_r w dpy -- status )
libX11 XGetIconSizes [ 4 ] ints (int) XGetIconSizes   ( count_r size_list_r w dpy -- status )
libX11 XGetNormalHints [ 3 ] ints (int) XGetNormalHints ( hints_r w dpy -- status )
libX11 XGetRGBColormaps [ 5 ] ints (int) XGetRGBColormaps        ( prop count_r stdcmap_r w dpy -- status )
libX11 XGetSizeHints [ 4 ] ints (int) XGetSizeHints   ( prop hints_r w dpy -- status )
libX11 XGetStandardColormap [ 4 ] ints (int) XGetStandardColormap    ( prop colormap_r w dpy -- status )
libX11 XGetTextProperty [ 4 ] ints (int) XGetTextProperty        ( prop text_prop_r w dpy -- status )
libX11 XGetWMClientMachine [ 3 ] ints (int) XGetWMClientMachine     ( text_prop_r w dpy -- status )
libX11 XGetWMHints [ 2 ] ints (int) XGetWMHints     ( w dpy -- WMHints* )
libX11 XGetWMIconName [ 3 ] ints (int) XGetWMIconName  ( text_prop_r w dpy -- status )
libX11 XGetWMName [ 3 ] ints (int) XGetWMName      ( text_prop_r w dpy -- status )
libX11 XGetWMNormalHints [ 4 ] ints (int) XGetWMNormalHints       ( supplied_r hints_r w dpy -- status )
libX11 XGetWMSizeHints [ 5 ] ints (int) XGetWMSizeHints ( prop supplied_r hints_r w dpy -- status )
libX11 XGetZoomHints [ 3 ] ints (int) XGetZoomHints   ( zhints_r w dpy -- status )
libX11 XConvertCase [ 3 ] ints (int) XConvertCase    ( upper* lower* sym -- r )
libX11 XMatchVisualInfo [ 5 ] ints (int) XMatchVisualInfo        ( vinfo_r class depth screen dpy -- status )
libX11 XOffsetRegion [ 3 ] ints (int) XOffsetRegion   ( dy dx reg -- r )
libX11 XPointInRegion [ 3 ] ints (int) XPointInRegion  ( y x reg -- flag )
libX11 XPolygonRegion [ 3 ] ints (int) XPolygonRegion  ( fill_rile n points -- reg )
libX11 XRectInRegion [ 5 ] ints (int) XRectInRegion   ( h w y x reg -- n )
libX11 XSaveContext [ 4 ] ints (int) XSaveContext    ( data context rid dpy -- n )
libX11 XSetIconSizes [ 4 ] ints (int) XSetIconSizes   ( count size_list w dpy -- r )
libX11 XSetNormalHints [ 3 ] ints (int) XSetNormalHints ( hints w dpy -- r )
libX11 XSetRGBColormaps [ 5 ] ints (int) XSetRGBColormaps        ( prop count stdcmaps w dpy -- r )
libX11 XSetSizeHints [ 4 ] ints (int) XSetSizeHints   ( prop hints w dpy -- r )
libX11 XSetStandardProperties [ 8 ] ints (int) XSetStandardProperties  ( sizehints argc argv icon_pixmap icon_name window_name w dpy -- r )
libX11 XSetWMClientMachine [ 3 ] ints (int) XSetWMClientMachine     ( text_prop w dpy -- r )
libX11 XSetWMIconName [ 3 ] ints (int) XSetWMIconName  ( text_prop w dpy -- r )
libX11 XSetWMName [ 3 ] ints (int) XSetWMName      ( text_prop w dpy -- r )
libX11 XSetWMProperties [ 9 ] ints (int) XSetWMProperties        ( class_hints wm_hints normal_hints argc argv icon_name window_name w dpy -- r )
libX11 XmbSetWMProperties [ 9 ] ints (int) XmbSetWMProperties      ( class_hints wm_hints normal_hints argc argv icon_name window_name w dpy -- r )
libX11 XSetWMSizeHints [ 4 ] ints (int) XSetWMSizeHints ( prop hints w dpy -- r )
libX11 XSetStandardColormap [ 4 ] ints (int) XSetStandardColormap    ( prop colormap w dpy -- r )
libX11 XSetZoomHints [ 3 ] ints (int) XSetZoomHints   ( zhints w dpy -- r )
libX11 XShrinkRegion [ 3 ] ints (int) XShrinkRegion   ( dy dx reg -- r )
libX11 XStringListToTextProperty [ 3 ] ints (int) XStringListToTextProperty       ( text_prop_r count list -- status )
libX11 XSubtractRegion [ 3 ] ints (int) XSubtractRegion ( dr_r srb sra -- r )
libX11 XmbTextListToTextProperty [ 5 ] ints (int) XmbTextListToTextProperty       ( text_prop_r style count list dpy -- n )
libX11 XwcTextListToTextProperty [ 5 ] ints (int) XwcTextListToTextProperty       ( text_prop_r style count list dpy -- n )
libX11 XTextPropertyToStringList [ 3 ] ints (int) XTextPropertyToStringList       ( count_r list_r text_prop -- status )
libX11 XmbTextPropertyToTextList [ 4 ] ints (int) XmbTextPropertyToTextList       ( count_r list_r text_prop dpy -- n )
libX11 XwcTextPropertyToTextList [ 4 ] ints (int) XwcTextPropertyToTextList       ( count_r list_r text_prop dpy -- n )
libX11 XUnionRegion [ 3 ] ints (int) XUnionRegion    ( dr_r srb sra -- r )
libX11 XWMGeometry [ &10 ] ints (int) XWMGeometry     ( gravity_r h_r w_r y_r x_r hints border_w default_geometry user_geometry screen_nr dpy -- n )
libX11 XXorRegion [ 3 ] ints (int) XXorRegion      ( dr_r srb sra -- r )

/* **************************************************************
 *
 * Memory Management
 *
 ****************************************************************/

libX11 XrmStringToQuarkList [ 2 ] ints (int) XrmStringToQuarkList    ( quarks string -- r )
libX11 XrmStringToBindingQuarkList [ 3 ] ints (int) XrmStringToBindingQuarkList     ( quarks bindings string -- r )

struct{
    cell size
    cell addr
} XrmValue

libX11 XrmQPutResource [ 5 ] ints (int) XrmQPutResource ( value type quarks bindings dbase -- r )
libX11 XrmPutResource [ 4 ] ints (int) XrmPutResource  ( value type spec dbase -- r )
libX11 XrmQPutStringResource [ 4 ] ints (int) XrmQPutStringResource   ( value quarks bindings dbase -- r )
libX11 XrmPutStringResource [ 3 ] ints (int) XrmPutStringResource    ( value spec dbase -- r )
libX11 XrmPutLineResource [ 2 ] ints (int) XrmPutLineResource      ( line dbase -- r )
libX11 XrmQGetResource [ 5 ] ints (int) XrmQGetResource ( value_r quark_t_r quark_c quark_n dbase -- r )
libX11 XrmGetResource [ 5 ] ints (int) XrmGetResource  ( value_r str_t_r str_c str_n dbase -- flag )
libX11 XrmQGetSearchList [ 5 ] ints (int) XrmQGetSearchList       ( list_len list_r classes names dbase -- flag )
libX11 XrmQGetSearchResource [ 5 ] ints (int) XrmQGetSearchResource   ( value_r type_r class name list -- flag )
libX11 XrmSetDatabase [ 2 ] ints (int) XrmSetDatabase  ( dbase dpy -- r )
libX11 XrmCombineFileDatabase [ 3 ] ints (int) XrmCombineFileDatabase  ( flag dbase* filename -- status )
libX11 XrmPutFileDatabase [ 2 ] ints (int) XrmPutFileDatabase      ( string dbase -- r )
libX11 XrmMergeDatabases [ 2 ] ints (int) XrmMergeDatabases       ( dbase* dbase -- r )
libX11 XrmCombineDatabase [ 3 ] ints (int) XrmCombineDatabase      ( flag dbase* dbase )
libX11 XrmEnumerateDatabase [ 6 ] ints (int) XrmEnumerateDatabase    ( closure callback mode class_prefix name_prefix db -- flag )
libX11 XrmParseCommand [ 6 ] ints (int) XrmParseCommand ( argv_io argc_io name table-count table dbase -- r )

\ X extensions

libXext XShmPutImage [ &11 ] ints (int) XShmPutImage            ( send_event h w dy dx sy sx im gc win dpy -- status )

previous

base !

include Xstring.fs

Module;
